using System;
using System.IO;

public class TooManyItemsException : ApplicationException
{
    public TooManyItemsException() : base(@"

**Wyjtek: ZbytWieleElementw** W kontenerze zostao umieszczonych zbyt wiele elementw. Podaj mniejsz warto lub zwiksz rozmiar kontenera.

")
    {
    }
}

public class NewException
{
    public static int Main(string[] args)
    {
        NewException myExceptionMaker = new NewException();

        try
        {
            myExceptionMaker.GenerateException(5);
        }
        catch (Exception e)
        {
            Console.WriteLine("\nKomunikat: {0}", e.Message);
        }
        finally
        {
            Console.WriteLine("\nWywoanie bloku finally z Main()");
        }

        return 0;
    }

    void GenerateException(int iterations)
    {
        int mySize = 3;
        byte[] myStream = new byte[mySize];
        StreamWriter sw = new StreamWriter("exceptions.txt");

        try
        {
            if (iterations > myStream.Length)
            {
                throw new TooManyItemsException();
            }

            for (byte b=0; b < iterations; b++)
            {
                sw.WriteLine("Byte {0}: {1}", b+1, b);
                myStream[b] = b;
            }
        }
        finally
        {
            Console.WriteLine("Wywoanie bloku finally z GenerateException.");
            sw.WriteLine("Zamykanie pliku");
            sw.Close();
        }
    }
}
